/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.OsUtils;
import com.kotcrab.vis.ui.util.dialog.Dialogs;
import com.kotcrab.vis.ui.util.dialog.InputDialogAdapter;
import com.kotcrab.vis.ui.util.dialog.InputDialogListener;
import com.kotcrab.vis.ui.util.dialog.OptionDialogAdapter;
import com.kotcrab.vis.ui.widget.ButtonBar;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisSplitPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.kotcrab.vis.ui.widget.file.FileChooserAdapter;
import com.kotcrab.vis.ui.widget.file.FileChooserListener;
import com.kotcrab.vis.ui.widget.file.FileChooserStyle;
import com.kotcrab.vis.ui.widget.file.FileUtils;
import com.kotcrab.vis.ui.widget.file.internal.DriveCheckerService;
import com.kotcrab.vis.ui.widget.file.internal.FavoritesIO;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserText;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserWinService;
import com.kotcrab.vis.ui.widget.file.internal.FileHistoryManager;
import com.kotcrab.vis.ui.widget.file.internal.FilePopupMenu;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class FileChooser
extends VisWindow
implements FileHistoryManager.FileHistoryCallback {
    private static final long FILE_WATCHER_CHECK_DELAY_MILLIS = 2000L;
    private static final ShortcutsComparator SHORTCUTS_COMPARATOR = new ShortcutsComparator();
    private Mode mode;
    private SelectionMode selectionMode = SelectionMode.FILES;
    private FileChooserListener listener = new FileChooserAdapter();
    private FileFilter fileFilter = new DefaultFileFilter(this);
    private FileIconProvider iconProvider = new DefaultFileIconProvider(this);
    private DriveCheckerService driveCheckerService = DriveCheckerService.getInstance();
    private FileChooserWinService chooserWinService = FileChooserWinService.getInstance();
    private FileDeleter fileDeleter = new DefaultFileDeleter();
    public static final int DEFAULT_KEY = -1;
    private boolean multiSelectionEnabled = false;
    private int groupMultiSelectKey = -1;
    private int multiSelectKey = -1;
    private FavoritesIO favoritesIO;
    private Array<FileHandle> favorites;
    private FileHandle currentDirectory;
    private ObjectMap<FileHandle, FileItem> items = new ObjectMap();
    private Array<FileItem> selectedItems = new Array();
    private ShortcutItem selectedShortcut;
    private boolean watchingFilesEnabled = true;
    private Thread fileWatcherThread;
    private boolean shortcutsListRebuildScheduled;
    private boolean filesListRebuildScheduled;
    private FileChooserStyle style;
    private Sizes sizes;
    private FileHistoryManager historyManager;
    private VisSplitPane mainSplitPane;
    private VisTable fileTable;
    private VisScrollPane fileScrollPane;
    private VisTable shortcutsTable;
    private VerticalGroup shortcutsMainPanel;
    private VerticalGroup shortcutsRootsPanel;
    private VerticalGroup shortcutsFavoritesPanel;
    private VisTextField currentPath;
    private VisTextField selectedFileTextField;
    private VisTextButton confirmButton;
    private FilePopupMenu fileMenu;

    public FileChooser(Mode mode) {
        this((FileHandle)null, mode);
    }

    public FileChooser(FileHandle directory, Mode mode) {
        super("");
        this.mode = mode;
        this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_FILES.get());
        this.style = VisUI.getSkin().get(FileChooserStyle.class);
        this.sizes = VisUI.getSizes();
        this.init(directory);
    }

    public FileChooser(String title, Mode mode) {
        this("default", title, mode);
    }

    public FileChooser(String styleName, String title, Mode mode) {
        super(title);
        this.mode = mode;
        this.style = VisUI.getSkin().get(styleName, FileChooserStyle.class);
        this.sizes = VisUI.getSizes();
        this.init(null);
    }

    public static void setFavoritesPrefsName(String name) {
        FavoritesIO.setFavoritesPrefsName(name);
    }

    private void init(FileHandle directory) {
        this.setModal(true);
        this.setResizable(true);
        this.setMovable(true);
        this.addCloseButton();
        this.closeOnEscape();
        this.favoritesIO = new FavoritesIO();
        this.favoritesIO.checkIfUsingDefaultName();
        this.favorites = this.favoritesIO.loadFavorites();
        this.createToolbar();
        this.createCenterContentPanel();
        this.createFileTextBox();
        this.createBottomButtons();
        this.createShortcutsMainPanel();
        this.shortcutsRootsPanel = new VerticalGroup();
        this.shortcutsFavoritesPanel = new VerticalGroup();
        this.rebuildShortcutsFavoritesPanel();
        this.fileMenu = new FilePopupMenu(this, this.style, new FilePopupMenu.FilePopupMenuCallback(){

            @Override
            public void showNewDirDialog() {
                FileChooser.this.showNewDirectoryDialog();
            }

            @Override
            public boolean delete(FileHandle fileHandle) throws IOException {
                return FileChooser.this.fileDeleter.delete(fileHandle);
            }
        });
        this.rebuildShortcutsList();
        if (directory == null) {
            this.setDirectory(Gdx.files.absolute(System.getProperty("user.home")), HistoryPolicy.IGNORE);
        } else {
            this.setDirectory(directory, HistoryPolicy.IGNORE);
        }
        this.setSize(500.0f, 600.0f);
        this.centerWindow();
        this.createListeners();
    }

    private void createToolbar() {
        VisTable toolbarTable = new VisTable(true);
        toolbarTable.defaults().minWidth(30.0f).right();
        this.add(toolbarTable).fillX().expandX().pad(3.0f).padRight(2.0f);
        this.historyManager = new FileHistoryManager(this.style, this);
        this.currentPath = new VisTextField();
        this.currentPath.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 66) {
                    FileHandle file = Gdx.files.absolute(FileChooser.this.currentPath.getText());
                    if (file.exists()) {
                        FileChooser.this.setDirectory(file, HistoryPolicy.ADD);
                    } else {
                        FileChooser.this.showDialog(FileChooserText.POPUP_DIRECTORY_DOES_NOT_EXIST.get());
                        FileChooser.this.currentPath.setText(FileChooser.this.currentDirectory.path());
                    }
                }
                return false;
            }
        });
        VisImageButton folderParentButton = new VisImageButton(this.style.iconFolderParent, FileChooserText.PARENT_DIRECTORY.get());
        VisImageButton folderNewButton = new VisImageButton(this.style.iconFolderNew, FileChooserText.NEW_DIRECTORY.get());
        toolbarTable.add(this.historyManager.getButtonsTable());
        toolbarTable.add(this.currentPath).expand().fill();
        toolbarTable.add(folderParentButton);
        toolbarTable.add(folderNewButton);
        folderParentButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileHandle parent = FileChooser.this.currentDirectory.parent();
                if (OsUtils.isWindows() && FileChooser.this.currentDirectory.path().endsWith(":/")) {
                    return;
                }
                FileChooser.this.setDirectory(parent, HistoryPolicy.ADD);
            }
        });
        folderNewButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.showNewDirectoryDialog();
            }
        });
        this.addListener(this.historyManager.getDefaultClickListener());
    }

    private void createCenterContentPanel() {
        this.fileTable = new VisTable();
        this.fileScrollPane = this.createScrollPane(this.fileTable);
        VisTable fileScrollPaneTable = new VisTable();
        fileScrollPaneTable.add(this.fileScrollPane).pad(2.0f).top().expand().fillX();
        fileScrollPaneTable.setTouchable(Touchable.enabled);
        this.shortcutsTable = new VisTable();
        final VisScrollPane shortcutsScrollPane = this.createScrollPane(this.shortcutsTable);
        VisTable shortcutsScrollPaneTable = new VisTable();
        shortcutsScrollPaneTable.add(shortcutsScrollPane).pad(2.0f).top().expand().fillX();
        this.mainSplitPane = new VisSplitPane((Actor)shortcutsScrollPaneTable, (Actor)fileScrollPaneTable, false){

            @Override
            public void invalidate() {
                super.invalidate();
                FileChooser.this.invalidateChildHierarchy(shortcutsScrollPane);
            }
        };
        this.mainSplitPane.setSplitAmount(0.3f);
        this.mainSplitPane.setMinSplitAmount(0.05f);
        this.mainSplitPane.setMaxSplitAmount(0.8913f);
        this.row();
        this.add(this.mainSplitPane).expand().fill();
        this.row();
        fileScrollPaneTable.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 1 && ((FileChooser)FileChooser.this).selectedItems.size == 0) {
                    FileChooser.this.fileMenu.build();
                    FileChooser.this.fileMenu.showMenu(FileChooser.this.getStage(), event.getStageX(), event.getStageY());
                }
            }
        });
    }

    private void invalidateChildHierarchy(WidgetGroup layout) {
        if (layout != null) {
            layout.invalidate();
            for (Actor actor : layout.getChildren()) {
                if (actor instanceof WidgetGroup) {
                    this.invalidateChildHierarchy((WidgetGroup)actor);
                    continue;
                }
                if (!(actor instanceof Layout)) continue;
                ((Layout)((Object)actor)).invalidate();
            }
        }
    }

    private void createFileTextBox() {
        VisTable table = new VisTable(true);
        VisLabel nameLabel = new VisLabel(FileChooserText.FILE_NAME.get());
        this.selectedFileTextField = new VisTextField();
        table.add(nameLabel);
        table.add(this.selectedFileTextField).expand().fill();
        this.selectedFileTextField.addListener(new InputListener(){

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                FileChooser.this.deselectAll(false);
                return false;
            }
        });
        this.add(table).expandX().fillX().pad(3.0f).padRight(2.0f).padBottom(2.0f);
        this.row();
    }

    private void createBottomButtons() {
        VisTextButton cancelButton = new VisTextButton(FileChooserText.CANCEL.get());
        this.confirmButton = new VisTextButton(this.mode == Mode.OPEN ? FileChooserText.OPEN.get() : FileChooserText.SAVE.get());
        VisTable buttonTable = new VisTable(true);
        buttonTable.defaults().minWidth(70.0f).right();
        this.add(buttonTable).padTop(3.0f).padBottom(3.0f).padRight(2.0f).fillX().expandX();
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setIgnoreSpacing(true);
        buttonBar.setButton(ButtonBar.ButtonType.CANCEL, cancelButton);
        buttonBar.setButton(ButtonBar.ButtonType.OK, this.confirmButton);
        buttonTable.add(buttonBar.createTable()).expand().right();
        cancelButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.fadeOut();
                FileChooser.this.listener.canceled();
            }
        });
        this.confirmButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.selectionFinished();
            }
        });
    }

    private void createShortcutsMainPanel() {
        this.shortcutsMainPanel = new VerticalGroup();
        String userHome = System.getProperty("user.home");
        String userName = System.getProperty("user.name");
        File userDesktop = new File(userHome + "/Desktop");
        if (userDesktop.exists()) {
            this.shortcutsMainPanel.addActor(new ShortcutItem(userDesktop, FileChooserText.DESKTOP.get(), this.style.iconFolder));
        }
        this.shortcutsMainPanel.addActor(new ShortcutItem(new File(userHome), userName, this.style.iconFolder));
    }

    private void createListeners() {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 29 && UIUtils.ctrl()) {
                    FileChooser.this.selectAll();
                    return true;
                }
                return false;
            }
        });
    }

    private void selectionFinished() {
        Array<FileHandle> files;
        if (this.selectedItems.size == 1) {
            FileHandle selected;
            if (this.selectionMode == SelectionMode.FILES && (selected = this.selectedItems.get((int)0).file).isDirectory()) {
                this.setDirectory(selected, HistoryPolicy.ADD);
                return;
            }
            if (this.selectionMode == SelectionMode.DIRECTORIES && !(selected = this.selectedItems.get((int)0).file).isDirectory()) {
                this.showDialog(FileChooserText.POPUP_ONLY_DIRECTORIES.get());
                return;
            }
        }
        if (this.selectedItems.size > 0 || this.mode == Mode.SAVE) {
            files = this.getFileListFromSelected();
            this.notifyListenerAndCloseDialog(files);
        } else if (this.selectionMode == SelectionMode.FILES) {
            this.showDialog(FileChooserText.POPUP_CHOOSE_FILE.get());
        } else {
            files = new Array();
            files.add(this.currentDirectory);
            this.notifyListenerAndCloseDialog(files);
        }
    }

    @Override
    protected void close() {
        this.listener.canceled();
        super.close();
    }

    private void notifyListenerAndCloseDialog(Array<FileHandle> files) {
        if (files == null) {
            return;
        }
        if (this.mode == Mode.OPEN) {
            for (FileHandle file : files) {
                if (file.exists()) continue;
                this.showDialog(FileChooserText.POPUP_SELECTED_FILE_DOES_NOT_EXIST.get());
                return;
            }
        }
        if (files.size != 0) {
            this.listener.selected(files);
        }
        this.fadeOut();
    }

    private VisScrollPane createScrollPane(VisTable table) {
        VisScrollPane scrollPane = new VisScrollPane((Actor)table);
        scrollPane.setOverscroll(false, true);
        scrollPane.setFadeScrollBars(false);
        scrollPane.setScrollingDisabled(true, false);
        return scrollPane;
    }

    private Array<FileHandle> getFileListFromSelected() {
        Array<FileHandle> list = new Array<FileHandle>();
        if (this.mode == Mode.OPEN) {
            for (FileItem f : this.selectedItems) {
                list.add(f.file);
            }
            return list;
        }
        if (this.selectedItems.size > 0) {
            for (FileItem f : this.selectedItems) {
                list.add(f.file);
            }
            this.showOverwriteQuestion(list);
            return null;
        }
        String fileName = this.selectedFileTextField.getText();
        FileHandle file = this.currentDirectory.child(fileName);
        if (!FileUtils.isValidFileName(fileName)) {
            this.showDialog(FileChooserText.POPUP_FILENAME_INVALID.get());
            return null;
        }
        if (file.exists()) {
            list.add(file);
            this.showOverwriteQuestion(list);
            return null;
        }
        list.add(file);
        return list;
    }

    private void showDialog(String text) {
        Dialogs.showOKDialog(this.getStage(), FileChooserText.POPUP_TITLE.get(), text);
    }

    private void showOverwriteQuestion(final Array<FileHandle> filesList) {
        String text = filesList.size == 1 ? FileChooserText.POPUP_FILE_EXIST_OVERWRITE.get() : FileChooserText.POPUP_MULTIPLE_FILE_EXIST_OVERWRITE.get();
        Dialogs.showOptionDialog(this.getStage(), FileChooserText.POPUP_TITLE.get(), text, Dialogs.OptionDialogType.YES_NO, new OptionDialogAdapter(){

            @Override
            public void yes() {
                FileChooser.this.notifyListenerAndCloseDialog(filesList);
            }
        });
    }

    private void rebuildShortcutsList(boolean rebuildRootCache) {
        this.shortcutsTable.clear();
        this.shortcutsTable.add(this.shortcutsMainPanel).left().row();
        this.shortcutsTable.addSeparator();
        if (rebuildRootCache) {
            this.rebuildFileRootsCache();
        }
        this.shortcutsTable.add(this.shortcutsRootsPanel).left().row();
        if (this.shortcutsFavoritesPanel.getChildren().size > 0) {
            this.shortcutsTable.addSeparator();
        }
        this.shortcutsTable.add(this.shortcutsFavoritesPanel).left().row();
    }

    private void rebuildShortcutsList() {
        this.shortcutsListRebuildScheduled = false;
        this.rebuildShortcutsList(true);
    }

    private void rebuildFileRootsCache() {
        File[] roots;
        this.shortcutsRootsPanel.clear();
        for (File root : roots = File.listRoots()) {
            this.driveCheckerService.addListener(root, this.mode == Mode.OPEN ? DriveCheckerService.RootMode.READABLE : DriveCheckerService.RootMode.WRITABLE, new DriveCheckerService.DriveCheckerListener(){

                @Override
                public void rootMode(File root, DriveCheckerService.RootMode mode) {
                    String initialName = root.toString();
                    if (initialName.equals("/")) {
                        initialName = FileChooserText.COMPUTER.get();
                    }
                    ShortcutItem item = new ShortcutItem(root, initialName, ((FileChooser)FileChooser.this).style.iconDrive);
                    if (OsUtils.isWindows()) {
                        FileChooser.this.chooserWinService.addListener(root, item);
                    }
                    FileChooser.this.shortcutsRootsPanel.addActor(item);
                    FileChooser.this.shortcutsRootsPanel.getChildren().sort(SHORTCUTS_COMPARATOR);
                }
            });
        }
    }

    private void rebuildShortcutsFavoritesPanel() {
        this.shortcutsFavoritesPanel.clear();
        if (this.favorites.size > 0) {
            for (FileHandle f : this.favorites) {
                this.shortcutsFavoritesPanel.addActor(new ShortcutItem(f.file(), f.name(), this.style.iconFolder));
            }
        }
    }

    private void rebuildFileList() {
        this.filesListRebuildScheduled = false;
        this.deselectAll();
        this.fileTable.clear();
        this.items.clear();
        FileHandle[] files = this.currentDirectory.list(this.fileFilter);
        this.currentPath.setText(this.currentDirectory.path());
        if (files.length == 0) {
            return;
        }
        Array<FileHandle> fileList = FileUtils.sortFiles(files);
        for (FileHandle file : fileList) {
            if (file.file() == null) continue;
            FileItem item = new FileItem(file);
            this.fileTable.add(item).expand().fill().row();
            this.items.put(file, item);
        }
        this.fileScrollPane.setScrollX(0.0f);
        this.fileScrollPane.setScrollY(0.0f);
    }

    public void setSelectedFiles(FileHandle ... files) {
        this.deselectAll(false);
        for (FileHandle file : files) {
            FileItem item = this.items.get(file);
            if (item == null) continue;
            item.select(false);
        }
        this.removeInvalidSelections();
        this.updateSelectedFileFieldText();
    }

    public void refresh() {
        this.rebuildShortcutsList();
        this.rebuildFileList();
    }

    public void addFavorite(FileHandle favourite) {
        this.favorites.add(favourite);
        this.favoritesIO.saveFavorites(this.favorites);
        this.rebuildShortcutsFavoritesPanel();
        this.rebuildShortcutsList(false);
    }

    public boolean removeFavorite(FileHandle favorite) {
        boolean removed = this.favorites.removeValue(favorite, false);
        this.favoritesIO.saveFavorites(this.favorites);
        this.rebuildShortcutsFavoritesPanel();
        this.rebuildShortcutsList(false);
        return removed;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isVisible() && visible) {
            this.deselectAll();
        }
        super.setVisible(visible);
    }

    private void deselectAll() {
        this.deselectAll(true);
    }

    private void deselectAll(boolean updateTextField) {
        for (FileItem item : this.selectedItems) {
            item.deselect(false);
        }
        this.selectedItems.clear();
        if (updateTextField) {
            this.updateSelectedFileFieldText();
        }
    }

    private void selectAll() {
        for (FileItem item : this.items.values()) {
            item.select(false);
        }
        this.removeInvalidSelections();
        this.updateSelectedFileFieldText();
    }

    private void updateSelectedFileFieldText() {
        if (this.selectedItems.size == 0) {
            this.selectedFileTextField.setText("");
        } else if (this.selectedItems.size == 1) {
            this.selectedFileTextField.setText(this.selectedItems.get((int)0).file.name());
        } else {
            StringBuilder b = new StringBuilder();
            for (FileItem item : this.selectedItems) {
                b.append('\"');
                b.append(item.file.name());
                b.append("\" ");
            }
            this.selectedFileTextField.setText(b.toString());
        }
    }

    private void removeInvalidSelections() {
        FileItem item;
        Iterator<FileItem> it;
        if (this.selectionMode == SelectionMode.FILES) {
            it = this.selectedItems.iterator();
            while (it.hasNext()) {
                item = it.next();
                if (!item.file.isDirectory()) continue;
                item.deselect(false);
                it.remove();
            }
        }
        if (this.selectionMode == SelectionMode.DIRECTORIES) {
            it = this.selectedItems.iterator();
            while (it.hasNext()) {
                item = it.next();
                if (item.file.isDirectory()) continue;
                item.deselect(false);
                it.remove();
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.confirmButton.setText(mode == Mode.OPEN ? FileChooserText.OPEN.get() : FileChooserText.SAVE.get());
        this.refresh();
    }

    public void setDirectory(String directory) {
        this.setDirectory(Gdx.files.absolute(directory), HistoryPolicy.CLEAR);
    }

    public void setDirectory(File directory) {
        this.setDirectory(Gdx.files.absolute(directory.getAbsolutePath()), HistoryPolicy.CLEAR);
    }

    public void setDirectory(FileHandle directory) {
        this.setDirectory(directory, HistoryPolicy.CLEAR);
    }

    @Override
    public void setDirectory(FileHandle directory, HistoryPolicy historyPolicy) {
        if (directory.equals(this.currentDirectory)) {
            return;
        }
        if (!directory.exists()) {
            throw new IllegalStateException("Provided directory does not exist!");
        }
        if (!directory.isDirectory()) {
            throw new IllegalStateException("Provided path is a file, not directory!");
        }
        if (historyPolicy == HistoryPolicy.ADD) {
            this.historyManager.historyAdd();
        }
        this.currentDirectory = directory;
        this.rebuildFileList();
        if (historyPolicy == HistoryPolicy.CLEAR) {
            this.historyManager.historyClear();
        }
    }

    @Override
    public FileHandle getCurrentDirectory() {
        return this.currentDirectory;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.rebuildFileList();
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        if (selectionMode == null) {
            selectionMode = SelectionMode.FILES;
        }
        this.selectionMode = selectionMode;
        switch (selectionMode) {
            case FILES: {
                this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_FILES.get());
                break;
            }
            case DIRECTORIES: {
                this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_DIRECTORIES.get());
                break;
            }
            case FILES_AND_DIRECTORIES: {
                this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_FILES_AND_DIRECTORIES.get());
            }
        }
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
    }

    public void setListener(FileChooserListener newListener) {
        this.listener = newListener;
        if (this.listener == null) {
            this.listener = new FileChooserAdapter();
        }
    }

    public int getMultiSelectKey() {
        return this.multiSelectKey;
    }

    public void setMultiSelectKey(int multiSelectKey) {
        this.multiSelectKey = multiSelectKey;
    }

    public int getGroupMultiSelectKey() {
        return this.groupMultiSelectKey;
    }

    public void setGroupMultiSelectKey(int groupMultiSelectKey) {
        this.groupMultiSelectKey = groupMultiSelectKey;
    }

    private boolean isMultiSelectKeyPressed() {
        if (this.multiSelectKey == -1) {
            return UIUtils.ctrl();
        }
        return Gdx.input.isKeyPressed(this.multiSelectKey);
    }

    private boolean isGroupMultiSelectKeyPressed() {
        if (this.groupMultiSelectKey == -1) {
            return UIUtils.shift();
        }
        return Gdx.input.isKeyPressed(this.groupMultiSelectKey);
    }

    FileChooserStyle getChooserStyle() {
        return this.style;
    }

    public void setWatchingFilesEnabled(boolean watchingFilesEnabled) {
        if (this.getStage() != null) {
            throw new IllegalStateException("Pooling setting cannot be changed when file chooser is added to Stage!");
        }
        this.watchingFilesEnabled = watchingFilesEnabled;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.shortcutsListRebuildScheduled) {
            this.rebuildShortcutsList();
        }
        if (this.filesListRebuildScheduled) {
            this.rebuildFileList();
        }
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (this.watchingFilesEnabled) {
            if (stage != null) {
                this.startFileWatcher();
            } else {
                this.stopFileWatcher();
            }
        }
    }

    private void startFileWatcher() {
        if (this.fileWatcherThread != null) {
            throw new IllegalStateException("FileWatcherThread already running");
        }
        this.fileWatcherThread = new Thread(new Runnable(){
            File[] lastRoots;
            FileHandle lastCurrentDirectory;
            FileHandle[] lastCurrentFiles;

            @Override
            public void run() {
                this.lastRoots = File.listRoots();
                this.lastCurrentDirectory = FileChooser.this.currentDirectory;
                this.lastCurrentFiles = FileChooser.this.currentDirectory.list();
                while (FileChooser.this.fileWatcherThread != null) {
                    Object[] roots = File.listRoots();
                    if (roots.length != this.lastRoots.length || !Arrays.equals(this.lastRoots, roots)) {
                        FileChooser.this.shortcutsListRebuildScheduled = true;
                    }
                    this.lastRoots = roots;
                    if (this.lastCurrentDirectory.equals(FileChooser.this.currentDirectory)) {
                        Object[] currentFiles = FileChooser.this.currentDirectory.list();
                        if (this.lastCurrentFiles.length != currentFiles.length || !Arrays.equals(this.lastCurrentFiles, currentFiles)) {
                            FileChooser.this.filesListRebuildScheduled = true;
                        }
                        this.lastCurrentFiles = currentFiles;
                    } else {
                        this.lastCurrentFiles = FileChooser.this.currentDirectory.list();
                    }
                    this.lastCurrentDirectory = FileChooser.this.currentDirectory;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "FileWatcherThread");
        this.fileWatcherThread.setDaemon(true);
        this.fileWatcherThread.start();
    }

    private void stopFileWatcher() {
        if (this.fileWatcherThread == null) {
            throw new IllegalStateException("FileWatcherThread not running");
        }
        this.fileWatcherThread.interrupt();
        this.fileWatcherThread = null;
    }

    private void showNewDirectoryDialog() {
        Dialogs.showInputDialog(this.getStage(), FileChooserText.NEW_DIRECTORY_DIALOG_TITLE.get(), FileChooserText.NEW_DIRECTORY_DIALOG_TEXT.get(), true, (InputDialogListener)new InputDialogAdapter(){

            @Override
            public void finished(String input) {
                if (!FileUtils.isValidFileName(input)) {
                    Dialogs.showErrorDialog(FileChooser.this.getStage(), FileChooserText.NEW_DIRECTORY_DIALOG_ILLEGAL_CHARACTERS.get());
                }
                for (FileHandle file : FileChooser.this.currentDirectory.list()) {
                    if (!file.name().equals(input)) continue;
                    Dialogs.showErrorDialog(FileChooser.this.getStage(), FileChooserText.NEW_DIRECTORY_DIALOG_ALREADY_EXISTS.get());
                    return;
                }
                FileChooser.this.currentDirectory.child(input).mkdirs();
                FileChooser.this.refresh();
            }
        });
    }

    public void setFileDeleter(FileDeleter fileDeleter) {
        if (fileDeleter == null) {
            throw new IllegalStateException("fileDeleter can't be null");
        }
        this.fileDeleter = fileDeleter;
        this.fileMenu.fileDeleterChanged(fileDeleter.hasTrash());
    }

    public void setIconProvider(FileIconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    private static class ShortcutsComparator
    implements Comparator<Actor> {
        private ShortcutsComparator() {
        }

        @Override
        public int compare(Actor o1, Actor o2) {
            ShortcutItem s1 = (ShortcutItem)o1;
            ShortcutItem s2 = (ShortcutItem)o2;
            return s1.getLabelText().compareTo(s2.getLabelText());
        }
    }

    private class ShortcutItem
    extends Table
    implements FileChooserWinService.RootNameListener {
        public File file;
        private VisLabel name;

        public ShortcutItem(File file, String customName, Drawable icon) {
            this.file = file;
            this.name = new VisLabel(customName);
            this.name.setEllipsis(true);
            this.add(new Image(icon)).padTop(3.0f);
            Cell<VisLabel> labelCell = this.add(this.name).padRight(6.0f);
            labelCell.width(new Value(){

                @Override
                public float get(Actor context) {
                    return ((FileChooser)FileChooser.this).mainSplitPane.getFirstWidgetBounds().width - 30.0f;
                }
            });
            this.addListener();
        }

        private void addListener() {
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == 1) {
                        FileChooser.this.fileMenu.buildForFavorite(FileChooser.this.favorites, ShortcutItem.this.file);
                        FileChooser.this.fileMenu.showMenu(ShortcutItem.this.getStage(), event.getStageX(), event.getStageY());
                    }
                }
            });
            this.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    FileChooser.this.deselectAll();
                    FileChooser.this.updateSelectedFileFieldText();
                    ShortcutItem.this.select();
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (this.getTapCount() == 1) {
                        File file = ShortcutItem.this.file;
                        if (!file.exists()) {
                            FileChooser.this.showDialog(FileChooserText.POPUP_DIRECTORY_DOES_NOT_EXIST.get());
                            FileChooser.this.refresh();
                            return;
                        }
                        if (file.isDirectory()) {
                            FileChooser.this.setDirectory(Gdx.files.absolute(file.getAbsolutePath()), HistoryPolicy.ADD);
                            ShortcutItem.this.getStage().setScrollFocus(FileChooser.this.fileScrollPane);
                        }
                    }
                }
            });
        }

        public void setLabelText(String text) {
            this.name.setText(text);
        }

        public String getLabelText() {
            return this.name.getText().toString();
        }

        private void select() {
            if (FileChooser.this.selectedShortcut != null) {
                FileChooser.this.selectedShortcut.deselect();
            }
            FileChooser.this.selectedShortcut = this;
            this.setBackground(((FileChooser)FileChooser.this).style.highlight);
        }

        private void deselect() {
            this.setBackground((Drawable)null);
        }

        @Override
        public void setRootName(String newName) {
            this.setLabelText(newName);
        }
    }

    private class FileItem
    extends Table {
        public FileHandle file;
        private VisLabel name;
        private VisLabel size;

        public FileItem(final FileHandle file) {
            this.file = file;
            this.setTouchable(Touchable.enabled);
            this.name = new VisLabel(file.name());
            this.name.setEllipsis(true);
            this.size = file.isDirectory() ? new VisLabel("") : new VisLabel(FileUtils.readableFileSize(file.length()));
            Drawable icon = FileChooser.this.iconProvider.provideIcon(file);
            if (icon != null) {
                this.add(new Image(icon)).padTop(3.0f);
            }
            Cell<VisLabel> labelCell = this.add(this.name).padLeft(icon == null ? 22.0f : 0.0f);
            labelCell.width(new Value(){

                @Override
                public float get(Actor context) {
                    int padding = (int)(file.isDirectory() ? 35.0f * ((FileChooser)FileChooser.this).sizes.scaleFactor : 60.0f * ((FileChooser)FileChooser.this).sizes.scaleFactor);
                    return ((FileChooser)FileChooser.this).mainSplitPane.getSecondWidgetBounds().width - (float)FileItem.this.getUsedWidth() - (float)padding;
                }
            });
            this.add(this.size).expandX().right().padRight(6.0f);
            this.addListener();
        }

        private int getUsedWidth() {
            Array<Cell> cells = this.getCells();
            int width = 0;
            for (Cell cell : cells) {
                if (cell.getActor() == this.name) continue;
                width = (int)((float)width + ((Actor)cell.getActor()).getWidth());
            }
            return width;
        }

        private void addListener() {
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == 1) {
                        FileChooser.this.fileMenu.build(FileChooser.this.favorites, FileItem.this.file);
                        FileChooser.this.fileMenu.showMenu(FileItem.this.getStage(), event.getStageX(), event.getStageY());
                    }
                }
            });
            this.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (FileChooser.this.selectedShortcut != null) {
                        FileChooser.this.selectedShortcut.deselect();
                    }
                    if (!FileChooser.this.multiSelectionEnabled || !FileChooser.this.isMultiSelectKeyPressed() && !FileChooser.this.isGroupMultiSelectKeyPressed()) {
                        FileChooser.this.deselectAll();
                    }
                    boolean itemSelected = FileItem.this.select();
                    if (((FileChooser)FileChooser.this).selectedItems.size > 1 && FileChooser.this.multiSelectionEnabled && FileChooser.this.isGroupMultiSelectKeyPressed()) {
                        this.selectGroup();
                    }
                    if (((FileChooser)FileChooser.this).selectedItems.size > 1) {
                        FileChooser.this.removeInvalidSelections();
                    }
                    FileChooser.this.updateSelectedFileFieldText();
                    if (!itemSelected) {
                        return false;
                    }
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (this.getTapCount() == 2 && FileChooser.this.selectedItems.contains(FileItem.this, true)) {
                        FileHandle file = FileItem.this.file;
                        if (file.isDirectory()) {
                            FileChooser.this.setDirectory(file, HistoryPolicy.ADD);
                        } else {
                            FileChooser.this.selectionFinished();
                        }
                    }
                }

                private void selectGroup() {
                    int end;
                    int start;
                    int lastSelectionIndex;
                    Array<Cell> cells = FileChooser.this.fileTable.getCells();
                    int thisSelectionIndex = this.getItemId(cells, FileItem.this);
                    if (thisSelectionIndex > (lastSelectionIndex = this.getItemId(cells, (FileItem)FileChooser.this.selectedItems.get(((FileChooser)FileChooser.this).selectedItems.size - 2)))) {
                        start = lastSelectionIndex;
                        end = thisSelectionIndex;
                    } else {
                        start = thisSelectionIndex;
                        end = lastSelectionIndex;
                    }
                    for (int i = start; i < end; ++i) {
                        FileItem item = (FileItem)cells.get(i).getActor();
                        item.select(false);
                    }
                }

                private int getItemId(Array<Cell> cells, FileItem item) {
                    for (int i = 0; i < cells.size; ++i) {
                        if (cells.get(i).getActor() != item) continue;
                        return i;
                    }
                    throw new IllegalStateException("Item not found in cells");
                }
            });
        }

        private boolean select() {
            return this.select(true);
        }

        private boolean select(boolean deselectIfAlreadySelected) {
            if (deselectIfAlreadySelected && FileChooser.this.selectedItems.contains(this, true)) {
                this.deselect();
                return false;
            }
            this.setBackground(((FileChooser)FileChooser.this).style.highlight);
            if (!FileChooser.this.selectedItems.contains(this, true)) {
                FileChooser.this.selectedItems.add(this);
            }
            return true;
        }

        private void deselect() {
            this.deselect(true);
        }

        private void deselect(boolean removeFromList) {
            this.setBackground((Drawable)null);
            if (removeFromList) {
                FileChooser.this.selectedItems.removeValue(this, true);
            }
        }
    }

    public static final class DefaultFileDeleter
    implements FileDeleter {
        @Override
        public boolean hasTrash() {
            return false;
        }

        @Override
        public boolean delete(FileHandle file) {
            return file.delete();
        }
    }

    static interface FileDeleter {
        public boolean hasTrash();

        public boolean delete(FileHandle var1) throws IOException;
    }

    public static class DefaultFileFilter
    implements FileFilter {
        private FileChooser chooser;

        public DefaultFileFilter(FileChooser chooser) {
            this.chooser = chooser;
        }

        @Override
        public boolean accept(File f) {
            if (f.isHidden()) {
                return false;
            }
            return !(this.chooser.getMode() == Mode.OPEN ? !f.canRead() : !f.canWrite());
        }
    }

    public static class DefaultFileIconProvider
    implements FileIconProvider {
        private FileChooser chooser;

        public DefaultFileIconProvider(FileChooser chooser) {
            this.chooser = chooser;
        }

        @Override
        public Drawable provideIcon(FileHandle file) {
            FileChooserStyle style = this.chooser.style;
            if (file.isDirectory()) {
                return style.iconFolder;
            }
            String ext = file.extension();
            if (ext.equals("jpg") || ext.equals("png")) {
                return style.iconFileImage;
            }
            if (ext.equals("wav") || ext.equals("ogg") || ext.equals("mp3")) {
                return style.iconFileAudio;
            }
            if (ext.equals("pdf")) {
                return style.iconFilePdf;
            }
            if (ext.equals("txt")) {
                return style.iconFileText;
            }
            return null;
        }
    }

    public static interface FileIconProvider {
        public Drawable provideIcon(FileHandle var1);
    }

    public static enum HistoryPolicy {
        ADD,
        CLEAR,
        IGNORE;

    }

    public static enum SelectionMode {
        FILES,
        DIRECTORIES,
        FILES_AND_DIRECTORIES;

    }

    public static enum Mode {
        OPEN,
        SAVE;

    }
}

