/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color.internal;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Pools;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.widget.color.ColorPickerWidgetStyle;
import com.kotcrab.vis.ui.widget.color.internal.PickerCommons;
import com.kotcrab.vis.ui.widget.color.internal.ShaderImage;

public class ChannelBar
extends ShaderImage {
    public static final int MODE_ALPHA = 0;
    public static final int MODE_R = 1;
    public static final int MODE_G = 2;
    public static final int MODE_B = 3;
    public static final int MODE_H = 4;
    public static final int MODE_S = 5;
    public static final int MODE_V = 6;
    protected ColorPickerWidgetStyle style;
    private Sizes sizes;
    private int maxValue;
    private int value;
    private float selectorX;
    private int mode;
    private ChannelBarListener channelBarListener;

    public ChannelBar(PickerCommons commons, int mode, int maxValue, ChangeListener changeListener) {
        super(commons.getBarShader(mode), commons.whiteTexture);
        this.style = commons.style;
        this.sizes = commons.sizes;
        this.mode = mode;
        this.maxValue = maxValue;
        this.setValue(this.value);
        this.addListener(changeListener);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                ChannelBar.this.updateValueFromTouch(x);
                return true;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                ChannelBar.this.updateValueFromTouch(x);
            }
        });
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.style.barSelector.draw(batch, this.getX() + this.selectorX - this.style.barSelector.getMinWidth() / 2.0f, this.getY() - 1.0f, this.style.barSelector.getMinWidth(), this.style.barSelector.getMinHeight());
    }

    public void setValue(int newValue) {
        this.value = newValue;
        if (this.value < 0) {
            this.value = 0;
        }
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
        this.selectorX = (float)this.value / (float)this.maxValue * 130.0f * this.sizes.scaleFactor;
    }

    public int getValue() {
        return this.value;
    }

    private void updateValueFromTouch(float x) {
        int newValue = (int)(x / 130.0f * (float)this.maxValue / this.sizes.scaleFactor);
        this.setValue(newValue);
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    @Override
    protected void setShaderUniforms(ShaderProgram shader) {
        shader.setUniformi("u_mode", this.mode);
        this.channelBarListener.setShaderUniforms(shader);
    }

    public void setChannelBarListener(ChannelBarListener channelBarListener) {
        this.channelBarListener = channelBarListener;
    }

    public static interface ChannelBarListener {
        public void updateFields();

        public void setShaderUniforms(ShaderProgram var1);
    }
}

