/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisImageButton;

public class VisWindow
extends Window {
    public static float FADE_TIME = 0.3f;
    private boolean centerOnAdd;

    public VisWindow(String title) {
        this(title, true);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    public VisWindow(String title, boolean showWindowBorder) {
        super(title, VisUI.getSkin(), showWindowBorder ? "default" : "noborder");
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    public VisWindow(String title, String styleName) {
        super(title, VisUI.getSkin(), styleName);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    public VisWindow(String title, Window.WindowStyle style) {
        super(title, style);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition((int)x, (int)y);
    }

    public boolean centerWindow() {
        Group parent = this.getParent();
        if (parent == null) {
            this.centerOnAdd = true;
            return false;
        }
        this.moveToCenter();
        return true;
    }

    public void setCenterOnAdd(boolean centerOnAdd) {
        this.centerOnAdd = centerOnAdd;
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (stage != null) {
            stage.setKeyboardFocus(this);
            if (this.centerOnAdd) {
                this.centerOnAdd = false;
                this.moveToCenter();
            }
        }
    }

    private void moveToCenter() {
        Stage parent = this.getStage();
        if (parent != null) {
            this.setPosition((parent.getWidth() - this.getWidth()) / 2.0f, (parent.getHeight() - this.getHeight()) / 2.0f);
        }
    }

    public void fadeOut(float time) {
        this.addAction(Actions.sequence((Action)Actions.fadeOut(time, Interpolation.fade), (Action)Actions.removeActor()));
    }

    public VisWindow fadeIn(float time) {
        this.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.addAction(Actions.fadeIn(time, Interpolation.fade));
        return this;
    }

    public void fadeOut() {
        this.fadeOut(FADE_TIME);
    }

    public VisWindow fadeIn() {
        return this.fadeIn(FADE_TIME);
    }

    protected void close() {
        this.fadeOut();
    }

    public void addCloseButton() {
        Label titleLabel = this.getTitleLabel();
        Table titleTable = this.getTitleTable();
        VisImageButton closeButton = new VisImageButton("close-window");
        titleTable.add(closeButton).padRight(-this.getPadRight() + 0.7f);
        closeButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                VisWindow.this.close();
            }
        });
        closeButton.addListener(new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.cancel();
                return true;
            }
        });
        if (titleLabel.getLabelAlign() == 1 && titleTable.getChildren().size == 2) {
            titleTable.getCell(titleLabel).padLeft(closeButton.getWidth() * 2.0f);
        }
    }

    public void closeOnEscape() {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 131) {
                    VisWindow.this.close();
                    return true;
                }
                return false;
            }

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 4) {
                    VisWindow.this.close();
                    return true;
                }
                return false;
            }
        });
    }
}

