/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.widget.VisTextField;

public class VisValidatableTextField
extends VisTextField {
    private Array<InputValidator> validators = new Array();
    private boolean validationEnabled = true;
    private LastValidFocusListener restoreFocusListener;
    private boolean restoreLastValid = false;
    private String lastValid;

    public VisValidatableTextField() {
        this.init();
    }

    public VisValidatableTextField(String text) {
        super(text);
        this.init();
    }

    public VisValidatableTextField(String text, String styleName) {
        super(text, styleName);
        this.init();
    }

    public VisValidatableTextField(String text, VisTextField.VisTextFieldStyle style) {
        super(text, style);
        this.init();
    }

    public VisValidatableTextField(InputValidator validator) {
        this.addValidator(validator);
        this.init();
    }

    public VisValidatableTextField(InputValidator ... validators) {
        for (InputValidator validator : validators) {
            this.addValidator(validator);
        }
        this.init();
    }

    public VisValidatableTextField(boolean restoreLastValid, InputValidator validator) {
        this.addValidator(validator);
        this.init();
        this.setRestoreLastValid(restoreLastValid);
    }

    public VisValidatableTextField(boolean restoreLastValid, InputValidator ... validators) {
        for (InputValidator validator : validators) {
            this.addValidator(validator);
        }
        this.init();
        this.setRestoreLastValid(restoreLastValid);
    }

    private void init() {
        this.setProgrammaticChangeEvents(true);
    }

    @Override
    void beforeChangeEventFired() {
        this.validateInput();
    }

    @Override
    public void setText(String str) {
        super.setText(str);
        this.validateInput();
    }

    public void validateInput() {
        if (this.validationEnabled) {
            for (InputValidator validator : this.validators) {
                if (validator.validateInput(this.getText())) continue;
                this.setInputValid(false);
                return;
            }
        }
        this.setInputValid(true);
    }

    public void addValidator(InputValidator validator) {
        this.validators.add(validator);
        this.validateInput();
    }

    public Array<InputValidator> getValidators() {
        return this.validators;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        this.validateInput();
    }

    public boolean isRestoreLastValid() {
        return this.restoreLastValid;
    }

    public void setRestoreLastValid(boolean restoreLastValid) {
        if (this.hasSelection) {
            throw new IllegalStateException("Last valid text restore can't be changed while filed has selection");
        }
        this.restoreLastValid = restoreLastValid;
        if (restoreLastValid) {
            if (this.restoreFocusListener == null) {
                this.restoreFocusListener = new LastValidFocusListener();
            }
            this.addListener(this.restoreFocusListener);
        } else {
            this.removeListener(this.restoreFocusListener);
        }
    }

    public void restoreLastValidText() {
        if (!this.restoreLastValid) {
            throw new IllegalStateException("Restore last valid is not enabled, see #setRestoreLastValid(boolean)");
        }
        VisValidatableTextField.super.setText(this.lastValid);
        this.setInputValid(true);
    }

    private class LastValidFocusListener
    extends FocusListener {
        private LastValidFocusListener() {
        }

        @Override
        public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
            if (focused && VisValidatableTextField.this.restoreLastValid) {
                VisValidatableTextField.this.lastValid = VisValidatableTextField.this.getText();
            }
            if (!focused && !VisValidatableTextField.this.isInputValid() && VisValidatableTextField.this.restoreLastValid) {
                VisValidatableTextField.this.restoreLastValidText();
            }
        }
    }
}

