/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.Focusable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.BorderOwner;

public class VisCheckBox
extends TextButton
implements Focusable,
BorderOwner {
    private Image image;
    private Cell imageCell;
    private VisCheckBoxStyle style;
    private boolean drawBorder;
    private boolean stateInvalid;
    private boolean focusBorderEnabled = true;

    public VisCheckBox(String text) {
        this(text, VisUI.getSkin().get(VisCheckBoxStyle.class));
    }

    public VisCheckBox(String text, boolean checked) {
        this(text, VisUI.getSkin().get(VisCheckBoxStyle.class));
        this.setChecked(checked);
    }

    public VisCheckBox(String text, String styleName) {
        this(text, VisUI.getSkin().get(styleName, VisCheckBoxStyle.class));
    }

    public VisCheckBox(String text, VisCheckBoxStyle style) {
        super(text, style);
        this.clearChildren();
        this.image = new Image(style.checkboxOff);
        this.imageCell = this.add(this.image);
        Label label = this.getLabel();
        this.add(label).padLeft(5.0f);
        label.setAlignment(8);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!VisCheckBox.this.isDisabled()) {
                    FocusManager.switchFocus(VisCheckBox.this.getStage(), VisCheckBox.this);
                }
                return false;
            }
        });
    }

    @Override
    public CheckBox.CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof VisCheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a VisCheckBoxStyle.");
        }
        super.setStyle(style);
        this.style = (VisCheckBoxStyle)style;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Drawable checkbox = this.getCheckboxImage();
        this.image.setDrawable(checkbox);
        super.draw(batch, parentAlpha);
        if (this.stateInvalid && this.style.errorBorder != null) {
            this.style.errorBorder.draw(batch, this.getX() + this.image.getX(), this.getY() + this.image.getY(), this.image.getWidth(), this.image.getHeight());
        } else if (this.focusBorderEnabled && this.drawBorder && this.style.focusBorder != null) {
            this.style.focusBorder.draw(batch, this.getX() + this.image.getX(), this.getY() + this.image.getY(), this.image.getWidth(), this.image.getHeight());
        }
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.imageCell;
    }

    public void setStateInvalid(boolean stateInvalid) {
        this.stateInvalid = stateInvalid;
    }

    public boolean setStateInvalid() {
        return this.stateInvalid;
    }

    @Override
    public void focusLost() {
        this.drawBorder = false;
    }

    @Override
    public void focusGained() {
        this.drawBorder = true;
    }

    protected Drawable getCheckboxImage() {
        if (this.isDisabled()) {
            if (this.isChecked()) {
                return this.style.checkboxOnDisabled;
            }
            return this.style.checkboxOffDisabled;
        }
        if (this.isPressed()) {
            if (this.isChecked()) {
                return this.style.checkboxOnDown;
            }
            return this.style.checkboxOffDown;
        }
        if (this.isChecked()) {
            if (this.isOver()) {
                return this.style.checkboxOnOver;
            }
            return this.style.checkboxOn;
        }
        if (this.isOver()) {
            return this.style.checkboxOver;
        }
        return this.style.checkboxOff;
    }

    @Override
    public boolean isFocusBorderEnabled() {
        return this.focusBorderEnabled;
    }

    @Override
    public void setFocusBorderEnabled(boolean focusBorderEnabled) {
        this.focusBorderEnabled = focusBorderEnabled;
    }

    public static class VisCheckBoxStyle
    extends CheckBox.CheckBoxStyle {
        public Drawable focusBorder;
        public Drawable errorBorder;
        public Drawable checkboxOnOver;
        public Drawable checkboxOnDown;
        public Drawable checkboxOffDown;

        public VisCheckBoxStyle() {
        }

        public VisCheckBoxStyle(Drawable checkboxOff, Drawable checkboxOn, BitmapFont font, Color fontColor) {
            super(checkboxOff, checkboxOn, font, fontColor);
        }

        public VisCheckBoxStyle(VisCheckBoxStyle style) {
            super(style);
            this.focusBorder = style.focusBorder;
            this.errorBorder = style.errorBorder;
            this.checkboxOnOver = style.checkboxOnOver;
            this.checkboxOnDown = style.checkboxOnDown;
            this.checkboxOffDown = style.checkboxOffDown;
        }
    }
}

