/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.ActorUtils;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.Separator;

public class PopupMenu
extends Table {
    private PopupMenuStyle style;
    private InputListener stageListener;
    private ChangeListener sharedMenuItemListener;
    private InputListener defaultInputListener;
    private PopupMenu subMenu;

    public PopupMenu() {
        this("default");
    }

    public PopupMenu(String styleName) {
        this(VisUI.getSkin().get(styleName, PopupMenuStyle.class));
    }

    public PopupMenu(PopupMenuStyle style) {
        this.style = style;
        this.setTouchable(Touchable.enabled);
        this.createListeners();
    }

    private void createListeners() {
        this.stageListener = new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!PopupMenu.this.menuStructureContains(x, y)) {
                    PopupMenu.this.remove();
                    return true;
                }
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (PopupMenu.this.subMenu != null) {
                    this.removeIfNeeded(x, y);
                }
            }

            private boolean removeIfNeeded(float x, float y) {
                if (!PopupMenu.this.contains(x, y)) {
                    PopupMenu.this.remove();
                    return true;
                }
                return false;
            }
        };
        this.sharedMenuItemListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!event.isStopped()) {
                    PopupMenu.this.remove();
                }
            }
        };
    }

    @Override
    public <T extends Actor> Cell<T> add(T actor) {
        if (actor instanceof MenuItem) {
            throw new IllegalArgumentException("MenuItems can be only added to PopupMenu by using addItem(MenuItem) method");
        }
        return super.add(actor);
    }

    public void addItem(MenuItem item) {
        super.add(item).fillX().row();
        this.pack();
        item.addListener(this.sharedMenuItemListener);
    }

    public void addSeparator() {
        this.add((T)new Separator("menu")).padTop(2.0f).padBottom(2.0f).fill().expand().row();
    }

    public InputListener getDefaultInputListener() {
        if (this.defaultInputListener == null) {
            this.defaultInputListener = new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == 1) {
                        PopupMenu.this.showMenu(event.getStage(), event.getStageX(), event.getStageY());
                    }
                }
            };
        }
        return this.defaultInputListener;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.style.background != null) {
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        super.draw(batch, parentAlpha);
        if (this.style.border != null) {
            this.style.border.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void showMenu(Stage stage, float x, float y) {
        this.setPosition(x, y - this.getHeight());
        if (stage.getHeight() - this.getY() > stage.getHeight()) {
            this.setY(this.getY() + this.getHeight());
        }
        ActorUtils.keepWithinStage(stage, this);
        stage.addActor(this);
    }

    public boolean contains(float x, float y) {
        return this.getX() <= x && this.getX() + this.getWidth() >= x && this.getY() <= y && this.getY() + this.getHeight() >= y;
    }

    public boolean menuStructureContains(float x, float y) {
        if (this.contains(x, y)) {
            return true;
        }
        if (this.subMenu != null) {
            return this.subMenu.menuStructureContains(x, y);
        }
        return false;
    }

    void setSubMenu(PopupMenu subMenu) {
        if (this.subMenu == subMenu) {
            return;
        }
        if (this.subMenu != null) {
            this.subMenu.remove();
        }
        this.subMenu = subMenu;
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (stage != null) {
            stage.addListener(this.stageListener);
        }
    }

    @Override
    public boolean remove() {
        if (this.getStage() != null) {
            this.getStage().removeListener(this.stageListener);
        }
        if (this.subMenu != null) {
            this.subMenu.remove();
        }
        return super.remove();
    }

    public static class PopupMenuStyle {
        public Drawable background;
        public Drawable border;

        public PopupMenuStyle() {
        }

        public PopupMenuStyle(Drawable background, Drawable border) {
            this.background = background;
            this.border = border;
        }

        public PopupMenuStyle(PopupMenuStyle style) {
            this.background = style.background;
            this.border = style.border;
        }
    }
}

