/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.FloatDigitsOnlyFilter;
import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.util.IntDigitsOnlyFilter;
import com.kotcrab.vis.ui.util.NumberDigitsTextFieldFilter;
import com.kotcrab.vis.ui.util.Validators;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;
import java.math.BigDecimal;

public class NumberSelector
extends VisTable {
    private Array<NumberSelectorListener> listeners = new Array();
    private InputValidator boundsValidator = new BoundsValidator();
    private VisValidatableTextField valueText;
    private NumberDigitsTextFieldFilter textFieldFilter;
    private Cell<VisLabel> labelCell;
    private ButtonRepeatTask buttonRepeatTask = new ButtonRepeatTask();
    private float buttonRepeatInitialTime = 0.4f;
    private float buttonRepeatTime = 0.08f;
    private boolean programmaticChangeEvents = true;
    private float max;
    private float min;
    private float step;
    private float current;
    private int precision = 0;

    public NumberSelector(String name, float initialValue, float min, float max) {
        this(name, initialValue, min, max, 1.0f);
    }

    public NumberSelector(String name, float initialValue, float min, float max, float step) {
        this("default", name, initialValue, min, max, step);
    }

    public NumberSelector(String name, float initialValue, float min, float max, float step, int precision) {
        this(VisUI.getSkin().get("default", NumberSelectorStyle.class), VisUI.getSizes(), name, initialValue, min, max, step, precision);
    }

    public NumberSelector(String styleName, String name, float initialValue, float min, float max, float step) {
        this(VisUI.getSkin().get(styleName, NumberSelectorStyle.class), VisUI.getSizes(), name, initialValue, min, max, step, 0);
    }

    public NumberSelector(String styleName, String name, float initialValue, float min, float max, float step, int precision) {
        this(VisUI.getSkin().get(styleName, NumberSelectorStyle.class), VisUI.getSizes(), name, initialValue, min, max, step, precision);
    }

    public NumberSelector(NumberSelectorStyle style, Sizes sizes, String name, float initialValue, float min, float max, float step) {
        this(style, sizes, name, initialValue, min, max, step, 0);
    }

    public NumberSelector(NumberSelectorStyle style, final Sizes sizes, String name, float initialValue, float min, float max, float step, int precision) {
        if (min > max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        if (step <= 0.0f) {
            throw new IllegalArgumentException("step must be > 0");
        }
        this.current = initialValue;
        this.max = max;
        this.min = min;
        this.step = step;
        this.valueText = new VisValidatableTextField(){

            @Override
            public float getPrefWidth() {
                return sizes.numberSelectorFieldSize;
            }
        };
        this.valueText.setProgrammaticChangeEvents(false);
        this.setPrecision(precision);
        this.valueText.setText(this.valueOf(this.current));
        VisTable buttonsTable = new VisTable();
        VisImageButton upButton = new VisImageButton(style.up);
        VisImageButton downButton = new VisImageButton(style.down);
        buttonsTable.add(upButton).height(sizes.numberSelectorButtonSize).row();
        buttonsTable.add(downButton).height(sizes.numberSelectorButtonSize);
        this.labelCell = this.add(new VisLabel(""));
        this.setSelectorName(name);
        this.add(this.valueText).fillX().expandX().height(sizes.numberSelectorButtonSize * 2.0f).padRight(sizes.numberSelectorFieldRightPadding);
        this.add(buttonsTable).width(sizes.numberSelectorButtonsWidth);
        this.addButtonsListeners(upButton, downButton);
        this.addTextFieldListeners();
    }

    private void addButtonsListeners(VisImageButton upButton, VisImageButton downButton) {
        upButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NumberSelector.this.getStage().setScrollFocus(NumberSelector.this.valueText);
                NumberSelector.this.increment(true);
            }
        });
        downButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NumberSelector.this.getStage().setScrollFocus(NumberSelector.this.valueText);
                NumberSelector.this.decrement(true);
            }
        });
        upButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!NumberSelector.this.buttonRepeatTask.isScheduled()) {
                    ((NumberSelector)NumberSelector.this).buttonRepeatTask.increment = true;
                    NumberSelector.this.buttonRepeatTask.cancel();
                    Timer.schedule(NumberSelector.this.buttonRepeatTask, NumberSelector.this.buttonRepeatInitialTime, NumberSelector.this.buttonRepeatTime);
                }
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                NumberSelector.this.buttonRepeatTask.cancel();
            }
        });
        downButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!NumberSelector.this.buttonRepeatTask.isScheduled()) {
                    ((NumberSelector)NumberSelector.this).buttonRepeatTask.increment = false;
                    NumberSelector.this.buttonRepeatTask.cancel();
                    Timer.schedule(NumberSelector.this.buttonRepeatTask, NumberSelector.this.buttonRepeatInitialTime, NumberSelector.this.buttonRepeatTime);
                }
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                NumberSelector.this.buttonRepeatTask.cancel();
            }
        });
    }

    private void addTextFieldListeners() {
        this.valueText.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NumberSelector.this.textChanged();
            }
        });
        this.valueText.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    try {
                        float newValue = Float.valueOf(NumberSelector.this.valueText.getText()).floatValue();
                        NumberSelector.this.setValue(newValue, true);
                    }
                    catch (NumberFormatException e) {
                        NumberSelector.this.valueChanged(true);
                    }
                    NumberSelector.this.getStage().setScrollFocus(null);
                }
            }
        });
        this.valueText.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                NumberSelector.this.getStage().setScrollFocus(NumberSelector.this.valueText);
                return true;
            }

            @Override
            public boolean scrolled(InputEvent event, float x, float y, int amount) {
                if (amount == 1) {
                    NumberSelector.this.decrement(true);
                } else {
                    NumberSelector.this.increment(true);
                }
                return true;
            }

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 66) {
                    NumberSelector.this.valueChanged(true);
                    return true;
                }
                return false;
            }
        });
    }

    public void setPrecision(final int precision) {
        if (precision < 0) {
            throw new IllegalStateException("Precision can't be < 0");
        }
        this.precision = precision;
        this.valueText.getValidators().clear();
        this.valueText.addValidator(this.boundsValidator);
        if (precision == 0) {
            this.valueText.addValidator(Validators.INTEGERS);
            this.textFieldFilter = new IntDigitsOnlyFilter(true);
            this.valueText.setTextFieldFilter(this.textFieldFilter);
        } else {
            this.valueText.addValidator(Validators.FLOATS);
            this.valueText.addValidator(new InputValidator(){

                @Override
                public boolean validateInput(String input) {
                    int dotIndex = input.indexOf(46);
                    if (dotIndex == -1) {
                        return true;
                    }
                    return input.length() - input.indexOf(46) - 1 <= precision;
                }
            });
            this.textFieldFilter = new FloatDigitsOnlyFilter(true);
            this.valueText.setTextFieldFilter(this.textFieldFilter);
        }
        this.textFieldFilter.setUseFieldCursorPosition(true);
        if (this.min >= 0.0f) {
            this.textFieldFilter.setAcceptNegativeValues(false);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setSelectorName(String name) {
        this.labelCell.getActor().setText(name);
        if (name == null || name.length() == 0) {
            this.labelCell.padRight(0.0f);
        } else {
            this.labelCell.padRight(6.0f);
        }
    }

    public String getSelectorName() {
        return super.getName();
    }

    private void textChanged() {
        if (this.valueText.getText().equals("")) {
            this.current = this.min;
        } else if (this.checkInputBounds(this.valueText.getText())) {
            this.current = Float.parseFloat(this.valueText.getText());
        }
    }

    public void increment() {
        this.increment(this.programmaticChangeEvents);
    }

    private void increment(boolean fireEvent) {
        this.current = this.current + this.step > this.max ? this.max : (this.current += this.step);
        this.valueChanged(fireEvent);
    }

    public void decrement() {
        this.decrement(this.programmaticChangeEvents);
    }

    private void decrement(boolean fireEvent) {
        this.current = this.current - this.step < this.min ? this.min : (this.current -= this.step);
        this.valueChanged(fireEvent);
    }

    public void setValue(float newValue) {
        this.setValue(newValue, this.programmaticChangeEvents);
    }

    public void setValue(float newValue, boolean fireEvent) {
        this.current = newValue > this.max ? this.max : (newValue < this.min ? this.min : newValue);
        this.valueChanged(fireEvent);
    }

    public float getValue() {
        return this.current;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        if (min > this.max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        this.min = min;
        if (min >= 0.0f) {
            this.textFieldFilter.setAcceptNegativeValues(false);
        } else {
            this.textFieldFilter.setAcceptNegativeValues(true);
        }
        if (this.current < min) {
            this.current = min;
            this.valueChanged(true);
        }
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        if (this.min > max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        this.max = max;
        if (this.current > max) {
            this.current = max;
            this.valueChanged(true);
        }
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        if (step <= 0.0f) {
            throw new IllegalArgumentException("step must be > 0");
        }
        this.step = step;
    }

    public int getMaxLength() {
        return this.valueText.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.valueText.setMaxLength(maxLength);
    }

    private boolean checkInputBounds(String input) {
        try {
            float x = Float.parseFloat(input);
            return x >= this.min && x <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void valueChanged(boolean fireEvent) {
        this.valueText.setCursorPosition(0);
        this.valueText.setText(this.valueOf(this.current));
        this.valueText.setCursorPosition(this.valueText.getText().length());
        if (fireEvent) {
            for (NumberSelectorListener listener : this.listeners) {
                listener.changed(this.current);
            }
        }
    }

    private String valueOf(float current) {
        if (this.precision >= 1) {
            BigDecimal bd = new BigDecimal(String.valueOf(current));
            bd = bd.setScale(this.precision, 4);
            return String.valueOf(bd.floatValue());
        }
        return String.valueOf((int)current);
    }

    public void addChangeListener(NumberSelectorListener listener) {
        if (listener != null && !this.listeners.contains(listener, true)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeChangeListener(NumberSelectorListener listener) {
        return this.listeners.removeValue(listener, true);
    }

    private class ButtonRepeatTask
    extends Timer.Task {
        boolean increment;

        private ButtonRepeatTask() {
        }

        @Override
        public void run() {
            if (this.increment) {
                NumberSelector.this.increment(true);
            } else {
                NumberSelector.this.decrement(true);
            }
        }
    }

    private class BoundsValidator
    implements InputValidator {
        private BoundsValidator() {
        }

        @Override
        public boolean validateInput(String input) {
            return NumberSelector.this.checkInputBounds(input);
        }
    }

    public static class NumberSelectorStyle {
        public Drawable up;
        public Drawable down;

        public NumberSelectorStyle() {
        }

        public NumberSelectorStyle(Drawable up, Drawable down) {
            this.up = up;
            this.down = down;
        }
    }

    public static interface NumberSelectorListener {
        public void changed(float var1);
    }
}

