/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.OsUtils;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.VisLabel;

public class MenuItem
extends Button {
    private Image image;
    private Label label;
    private MenuItemStyle style;
    private boolean generateDisabledImage = true;
    private Color shortcutLabelColor;
    private VisLabel shortcutLabel;
    private PopupMenu subMenu;
    private Image subMenuImage;
    private Cell<Image> subMenuIconCell;

    public MenuItem(String text) {
        this(text, (Image)null, VisUI.getSkin().get(MenuItemStyle.class));
    }

    public MenuItem(String text, ChangeListener changeListener) {
        this(text, (Image)null, VisUI.getSkin().get(MenuItemStyle.class));
        this.addListener(changeListener);
    }

    public MenuItem(String text, Drawable drawable) {
        this(text, drawable, VisUI.getSkin().get(MenuItemStyle.class));
    }

    public MenuItem(String text, Drawable drawable, ChangeListener changeListener) {
        this(text, drawable, VisUI.getSkin().get(MenuItemStyle.class));
        this.addListener(changeListener);
    }

    public MenuItem(String text, Image image) {
        this(text, image, VisUI.getSkin().get(MenuItemStyle.class));
    }

    public MenuItem(String text, Image image, ChangeListener changeListener) {
        this(text, image, VisUI.getSkin().get(MenuItemStyle.class));
        this.addListener(changeListener);
    }

    public MenuItem(String text, Image image, MenuItemStyle style) {
        super(style);
        this.init(text, image, style);
    }

    public MenuItem(String text, Drawable drawable, MenuItemStyle style) {
        super(style);
        this.init(text, new Image(drawable), style);
    }

    private void init(String text, Image image, MenuItemStyle style) {
        this.style = style;
        this.image = image;
        this.setSkin(VisUI.getSkin());
        Sizes sizes = VisUI.getSizes();
        this.defaults().space(3.0f);
        if (image != null) {
            image.setScaling(Scaling.fit);
        }
        this.add(image).size(sizes.menuItemIconSize);
        this.label = new Label((CharSequence)text, new Label.LabelStyle(style.font, style.fontColor));
        this.label.setAlignment(8);
        this.add(this.label).expand().fill();
        this.shortcutLabel = new VisLabel((CharSequence)"", "menuitem-shortcut");
        this.add(this.shortcutLabel).padLeft(10.0f).right();
        this.shortcutLabelColor = this.shortcutLabel.getStyle().fontColor;
        this.subMenuImage = new Image(style.subMenu);
        this.subMenuIconCell = this.add(this.subMenuImage).padLeft(3.0f).padRight(3.0f).size(style.subMenu.getMinWidth(), style.subMenu.getMinHeight());
        this.subMenuIconCell.setActor(null);
        this.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (MenuItem.this.subMenu != null) {
                    event.stop();
                }
            }
        });
        this.addListener(new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (MenuItem.this.subMenu == null || MenuItem.this.isDisabled()) {
                    PopupMenu parent = (PopupMenu)MenuItem.this.getParent();
                    parent.setSubMenu(null);
                } else {
                    Stage stage = MenuItem.this.getStage();
                    Vector2 pos = MenuItem.this.localToStageCoordinates(new Vector2(0.0f, 0.0f));
                    float subMenuX = pos.x + MenuItem.this.getWidth() + MenuItem.this.subMenu.getWidth() >= stage.getWidth() ? pos.x - MenuItem.this.getWidth() + 3.0f : pos.x + MenuItem.this.getWidth() - 1.0f;
                    MenuItem.this.subMenu.setPosition(subMenuX, pos.y - MenuItem.this.subMenu.getHeight() + MenuItem.this.getHeight());
                    if (MenuItem.this.subMenu.getY() < 0.0f) {
                        MenuItem.this.subMenu.setY(MenuItem.this.subMenu.getY() + MenuItem.this.subMenu.getHeight() - MenuItem.this.getHeight());
                    }
                    stage.addActor(MenuItem.this.subMenu);
                    PopupMenu parent = (PopupMenu)MenuItem.this.getParent();
                    parent.setSubMenu(MenuItem.this.subMenu);
                }
            }
        });
    }

    public void setSubMenu(PopupMenu subMenu) {
        this.subMenu = subMenu;
        if (subMenu == null) {
            this.subMenuIconCell.setActor(null);
        } else {
            this.subMenuIconCell.setActor(this.subMenuImage);
        }
    }

    @Override
    public MenuItemStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof MenuItemStyle)) {
            throw new IllegalArgumentException("style must be a MenuItemStyle.");
        }
        super.setStyle(style);
        this.style = (MenuItemStyle)style;
        if (this.label != null) {
            TextButton.TextButtonStyle textButtonStyle = (TextButton.TextButtonStyle)style;
            Label.LabelStyle labelStyle = this.label.getStyle();
            labelStyle.font = textButtonStyle.font;
            labelStyle.fontColor = textButtonStyle.fontColor;
            this.label.setStyle(labelStyle);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Color fontColor = this.isDisabled() && this.style.disabledFontColor != null ? this.style.disabledFontColor : (this.isPressed() && this.style.downFontColor != null ? this.style.downFontColor : (this.isChecked() && this.style.checkedFontColor != null ? (this.isOver() && this.style.checkedOverFontColor != null ? this.style.checkedOverFontColor : this.style.checkedFontColor) : (this.isOver() && this.style.overFontColor != null ? this.style.overFontColor : this.style.fontColor)));
        if (fontColor != null) {
            this.label.getStyle().fontColor = fontColor;
        }
        this.shortcutLabel.getStyle().fontColor = this.isDisabled() ? this.style.disabledFontColor : this.shortcutLabelColor;
        if (this.image != null && this.generateDisabledImage) {
            if (this.isDisabled()) {
                this.image.setColor(Color.GRAY);
            } else {
                this.image.setColor(Color.WHITE);
            }
        }
        super.draw(batch, parentAlpha);
    }

    public boolean isGenerateDisabledImage() {
        return this.generateDisabledImage;
    }

    public void setGenerateDisabledImage(boolean generateDisabledImage) {
        this.generateDisabledImage = generateDisabledImage;
    }

    public MenuItem setShortcut(int keycode) {
        return this.setShortcut(Input.Keys.toString(keycode));
    }

    public CharSequence getShortcut() {
        return this.shortcutLabel.getText();
    }

    public MenuItem setShortcut(String text) {
        this.shortcutLabel.setText(text);
        this.packParentMenu();
        return this;
    }

    public MenuItem setShortcut(int ... keycodes) {
        this.shortcutLabel.setText(OsUtils.getShortcutFor(keycodes));
        this.packParentMenu();
        return this;
    }

    private void packParentMenu() {
        if (this.getParent() instanceof PopupMenu) {
            PopupMenu menu = (PopupMenu)this.getParent();
            menu.pack();
        }
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        this.label.invalidate();
    }

    public Image getImage() {
        return this.image;
    }

    public Cell<?> getImageCell() {
        return this.getCell(this.image);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell<?> getLabelCell() {
        return this.getCell(this.label);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public void setText(CharSequence text) {
        this.label.setText(text);
    }

    public static class MenuItemStyle
    extends TextButton.TextButtonStyle {
        public Drawable subMenu;

        public MenuItemStyle() {
        }

        public MenuItemStyle(Drawable subMenu) {
            this.subMenu = subMenu;
        }

        public MenuItemStyle(MenuItemStyle other) {
            super(other);
            this.subMenu = other.subMenu;
        }
    }
}

