/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.Locales;
import com.kotcrab.vis.ui.util.OsUtils;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;

public class ButtonBar {
    public static final String WINDOWS_ORDER = "L H BEF YNOCA R";
    public static final String OSX_ORDER = "L H BEF NYCOA R";
    public static final String LINUX_ORDER = "L H NYACBEFO R";
    private ObjectMap<Character, Button> buttons = new ObjectMap();
    private boolean ignoreSpacing;
    private String order;

    public ButtonBar(String order) {
        if (order == null) {
            throw new IllegalArgumentException("order can't be null");
        }
        this.order = order;
    }

    public ButtonBar() {
        this.order = OsUtils.isWindows() ? WINDOWS_ORDER : (OsUtils.isMac() ? OSX_ORDER : LINUX_ORDER);
    }

    public boolean isIgnoreSpacing() {
        return this.ignoreSpacing;
    }

    public void setIgnoreSpacing(boolean ignoreSpacing) {
        this.ignoreSpacing = ignoreSpacing;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        if (order == null) {
            throw new IllegalArgumentException("order can't be null");
        }
        this.order = order;
    }

    public void setButton(ButtonType type, ChangeListener listener) {
        this.setButton(type, type.getText(), listener);
    }

    public void setButton(ButtonType type, String text, ChangeListener listener) {
        this.setButton(type, new VisTextButton(text), listener);
    }

    public void setButton(ButtonType type, Button button) {
        this.setButton(type, button, null);
    }

    public void setButton(ButtonType type, Button button, ChangeListener listener) {
        if (type == null) {
            throw new IllegalArgumentException("type can't be null");
        }
        if (button == null) {
            throw new IllegalArgumentException("button can't be null");
        }
        if (this.buttons.containsKey(Character.valueOf(type.id))) {
            this.buttons.remove(Character.valueOf(type.id));
        }
        this.buttons.put(Character.valueOf(type.id), button);
        if (listener != null) {
            button.addListener(listener);
        }
    }

    public Button getButton(ButtonType type) {
        return this.buttons.get(Character.valueOf(type.getId()));
    }

    public VisTextButton getTextButton(ButtonType type) {
        return (VisTextButton)this.getButton(type);
    }

    public VisTable createTable() {
        VisTable table = new VisTable(true);
        table.left();
        boolean spacingValid = false;
        for (int i = 0; i < this.order.length(); ++i) {
            Button button;
            char ch = this.order.charAt(i);
            if (!this.ignoreSpacing && ch == ' ' && spacingValid) {
                table.add().width(10.0f);
                spacingValid = false;
            }
            if ((button = this.buttons.get(Character.valueOf(ch))) == null) continue;
            table.add(button);
            spacingValid = true;
        }
        return table;
    }

    public static enum ButtonType {
        LEFT("left", 'L'),
        RIGHT("right", 'R'),
        HELP("help", 'H'),
        NO("no", 'N'),
        YES("yes", 'Y'),
        CANCEL("cancel", 'C'),
        BACK("back", 'B'),
        NEXT("next", 'E'),
        APPLY("apply", 'A'),
        FINISH("finish", 'F'),
        OK("ok", 'O');

        private final String key;
        private final char id;

        private ButtonType(String key, char id) {
            this.key = key;
            this.id = id;
        }

        public char getId() {
            return this.id;
        }

        public final String getText() {
            return Locales.getButtonBarBundle().get(this.key);
        }

        public final String toString() {
            return this.getText();
        }
    }
}

