/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util;

import com.kotcrab.vis.ui.util.InputValidator;

public class Validators {
    public static final IntegerValidator INTEGERS = new IntegerValidator();
    public static final FloatValidator FLOATS = new FloatValidator();

    public static class GreaterThanValidator
    implements InputValidator {
        private float greaterThan;
        private boolean useEquals;

        public GreaterThanValidator(float greaterThan) {
            this.greaterThan = greaterThan;
        }

        public GreaterThanValidator(float greaterThan, boolean inputCanBeEqual) {
            this.greaterThan = greaterThan;
            this.useEquals = inputCanBeEqual;
        }

        @Override
        public boolean validateInput(String input) {
            try {
                float value = Float.valueOf(input).floatValue();
                return this.useEquals ? value >= this.greaterThan : value > this.greaterThan;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        public void setUseEquals(boolean useEquals) {
            this.useEquals = useEquals;
        }

        public void setGreaterThan(float greaterThan) {
            this.greaterThan = greaterThan;
        }
    }

    public static class LesserThanValidator
    implements InputValidator {
        private float lesserThan;
        private boolean equals;

        public LesserThanValidator(float lesserThan) {
            this.lesserThan = lesserThan;
        }

        public LesserThanValidator(float lesserThan, boolean inputCanBeEqual) {
            this.lesserThan = lesserThan;
            this.equals = inputCanBeEqual;
        }

        @Override
        public boolean validateInput(String input) {
            try {
                float value = Float.valueOf(input).floatValue();
                return this.equals ? value <= this.lesserThan : value < this.lesserThan;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        public void setUseEquals(boolean equals) {
            this.equals = equals;
        }

        public void setLesserThan(float lesserThan) {
            this.lesserThan = lesserThan;
        }
    }

    public static class FloatValidator
    implements InputValidator {
        @Override
        public boolean validateInput(String input) {
            try {
                Float.parseFloat(input);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    public static class IntegerValidator
    implements InputValidator {
        @Override
        public boolean validateInput(String input) {
            try {
                Integer.parseInt(input);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

